<?php
/*--------------------------------------------------------------
   ImageDoesNotExistException.php 2020-07-28
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\ProductImageList\Exceptions;

use Exception;
use Throwable;

/**
 * Class ImageDoesNotExistException
 * @package Gambio\ProductImageList\Exceptions
 */
class ImageDoesNotExistException extends Exception
{
    /**
     * @param int            $id
     * @param Throwable|null $previous
     *
     * @return static
     */
    final public static function forId(int $id, Throwable $previous = null): self
    {
        $message = 'No image was found with the id: ' . $id;
        
        return new static($message, 1, $previous);
    }
}